/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWWorkBasketFilterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.query.VWOperatorComboBoxRenderer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.AbstractTableModel;

class VWWorkBasketFilterTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 5;
    protected static final int COL_NAME = 0;
    protected static final int COL_FIELD = 1;
    protected static final int COL_OPERATOR = 2;
    protected static final int COL_PROMPT = 3;
    protected static final int COL_DESCRIPTION = 4;
    private VWSessionInfo m_sessionInfo = null;
    private VWWorkBasketDefinition m_workBasketDef = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;

    public VWWorkBasketFilterTableModel(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
        this.m_rowData = new Vector();
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return VWExposedFieldDefinition.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Name;
            }
            case 1: {
                return VWResource.Field;
            }
            case 2: {
                return VWResource.Operator;
            }
            case 3: {
                return VWResource.LabelInUI;
            }
            case 4: {
                return VWResource.ToolTip;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowData.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWWorkBasketFilterDefinition workBasketFilterDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (workBasketFilterDef == null) break;
                    return workBasketFilterDef.getName();
                }
                case 1: {
                    if (workBasketFilterDef == null) break;
                    return workBasketFilterDef.getSearchField();
                }
                case 2: {
                    if (workBasketFilterDef == null) break;
                    return workBasketFilterDef.getOperator();
                }
                case 3: {
                    if (workBasketFilterDef == null) break;
                    return workBasketFilterDef.getPrompt();
                }
                case 4: {
                    if (workBasketFilterDef == null) break;
                    return workBasketFilterDef.getDescription();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    this.onUpdateName(aValue, nRowIndex);
                    break;
                }
                case 1: {
                    this.onUpdateField(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateOperator(aValue, nRowIndex);
                    break;
                }
                case 3: {
                    this.onUpdatePrompt(aValue, nRowIndex);
                    break;
                }
                case 4: {
                    this.onUpdateDescription(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setWorkBasketDefinition(VWWorkBasketDefinition workBasketDef) {
        try {
            try {
                VWWorkBasketFilterDefinition[] workBasketFilterDefs;
                this.m_workBasketDef = workBasketDef;
                this.m_rowData = new Vector();
                if (this.m_workBasketDef != null && (workBasketFilterDefs = this.m_workBasketDef.getWorkBasketFilterDefinitions()) != null) {
                    for (int nIndex = 0; nIndex < workBasketFilterDefs.length; ++nIndex) {
                        this.m_rowData.addElement(workBasketFilterDefs[nIndex]);
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                this.m_bIsModified = false;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            this.m_bIsModified = false;
            throw throwable;
        }
        this.fireTableDataChanged();
        this.m_bIsModified = false;
    }

    protected void addNewWorkBasketFilter() throws Exception {
        String newWorkBasketFilterName = VWResource.WorkBasketFilterNameTemplate.toString(Integer.toString(this.getRowCount() + 1));
        VWWorkBasketFilterDefinition newWorkBasketFilterDef = this.m_workBasketDef.createWorkBasketFilterDefinition(newWorkBasketFilterName);
        newWorkBasketFilterDef.setPrompt(newWorkBasketFilterName);
        this.m_rowData.addElement(newWorkBasketFilterDef);
        this.m_bIsModified = true;
        int nLastRow = this.getRowCount() - 1;
        this.fireTableRowsInserted(nLastRow, nLastRow);
    }

    protected void copyWorkBasketFilterAtIndex(int nRowIndex) {
        try {
            String copyOfString;
            VWWorkBasketFilterDefinition newWorkBasketFilterDef;
            VWWorkBasketFilterDefinition workBasketFilterDef = this.getRowItemAt(nRowIndex);
            if (workBasketFilterDef != null && (newWorkBasketFilterDef = this.m_workBasketDef.createCopyOfWorkBasketFilterDefinition(copyOfString = VWResource.CopyOf.toString(workBasketFilterDef.getName()), workBasketFilterDef)) != null) {
                this.m_rowData.addElement(newWorkBasketFilterDef);
                this.m_bIsModified = true;
                int nLastRow = this.getRowCount() - 1;
                this.fireTableRowsInserted(nLastRow, nLastRow);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected void deleteWorkBasketFilterAtIndex(int nRowIndex) {
        try {
            VWWorkBasketFilterDefinition workBasketFilterDef = this.getRowItemAt(nRowIndex);
            this.m_workBasketDef.deleteWorkBasketFilterDefinition(workBasketFilterDef.getName());
            this.m_rowData.removeElement(workBasketFilterDef);
            this.m_bIsModified = true;
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    protected VWWorkBasketFilterDefinition getRowItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWWorkBasketFilterDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        this.m_bIsModified = false;
    }

    protected void releaseResources() {
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        this.m_workBasketDef = null;
    }

    private void onUpdateName(Object aValue, int nRowIndex) throws Exception {
        String newName;
        if (aValue == null || !(aValue instanceof String)) {
            return;
        }
        VWWorkBasketFilterDefinition workBasketFilterDef = this.getRowItemAt(nRowIndex);
        if (workBasketFilterDef != null && VWStringUtils.compare(newName = (String)aValue, workBasketFilterDef.getName()) != 0) {
            boolean bUpdateLabel = VWStringUtils.compare(workBasketFilterDef.getName(), workBasketFilterDef.getPrompt()) == 0;
            workBasketFilterDef.setName(newName);
            this.m_bIsModified = true;
            this.fireTableCellUpdated(nRowIndex, 0);
            if (bUpdateLabel) {
                workBasketFilterDef.setPrompt(workBasketFilterDef.getName());
                this.fireTableCellUpdated(nRowIndex, 3);
            }
        }
    }

    private void onUpdateField(Object aValue, int nRowIndex) throws Exception {
        if (aValue == null || !(aValue instanceof VWExposedFieldDefinition)) {
            return;
        }
        VWWorkBasketFilterDefinition workBasketFilterDef = this.getRowItemAt(nRowIndex);
        if (workBasketFilterDef != null) {
            VWExposedFieldDefinition newField = (VWExposedFieldDefinition)aValue;
            VWExposedFieldDefinition currentField = workBasketFilterDef.getSearchField();
            if (currentField == null || VWStringUtils.compare(newField.getName(), currentField.getName()) != 0) {
                int nOperator = 0;
                DefaultComboBoxModel cbModel = VWOperatorComboBoxRenderer.getComboBoxModel(newField.getFieldType(), false);
                if (cbModel != null && cbModel.getSize() > 0) {
                    nOperator = (Integer)cbModel.getElementAt(0);
                }
                workBasketFilterDef.setSearchField(newField, nOperator);
                this.m_bIsModified = true;
                this.fireTableCellUpdated(nRowIndex, 1);
                this.fireTableCellUpdated(nRowIndex, 2);
            }
        }
    }

    private void onUpdateOperator(Object aValue, int nRowIndex) throws Exception {
        int newOperator;
        if (aValue == null || !(aValue instanceof Integer)) {
            return;
        }
        VWWorkBasketFilterDefinition workBasketFilterDef = this.getRowItemAt(nRowIndex);
        if (workBasketFilterDef != null && (newOperator = ((Integer)aValue).intValue()) != workBasketFilterDef.getOperator()) {
            workBasketFilterDef.setOperator(newOperator);
            this.m_bIsModified = true;
            this.fireTableCellUpdated(nRowIndex, 2);
        }
    }

    private void onUpdatePrompt(Object aValue, int nRowIndex) throws Exception {
        String newPrompt;
        if (aValue == null || !(aValue instanceof String)) {
            return;
        }
        VWWorkBasketFilterDefinition workBasketFilterDef = this.getRowItemAt(nRowIndex);
        if (workBasketFilterDef != null && VWStringUtils.compare(newPrompt = (String)aValue, workBasketFilterDef.getPrompt()) != 0) {
            workBasketFilterDef.setPrompt(newPrompt);
            this.m_bIsModified = true;
            this.fireTableCellUpdated(nRowIndex, 3);
        }
    }

    private void onUpdateDescription(Object aValue, int nRowIndex) throws Exception {
        String newDescription;
        if (aValue == null || !(aValue instanceof String)) {
            return;
        }
        VWWorkBasketFilterDefinition workBasketFilterDef = this.getRowItemAt(nRowIndex);
        if (workBasketFilterDef != null && VWStringUtils.compare(newDescription = (String)aValue, workBasketFilterDef.getDescription()) != 0) {
            workBasketFilterDef.setDescription(newDescription);
            this.m_bIsModified = true;
            this.fireTableCellUpdated(nRowIndex, 4);
        }
    }
}

